--> pralable
-- USE BD_Air_France;

-- Fonctions avances de groupe

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), cmp_compa VARCHAR(4));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380','EJ');

-- GROUP BY ROLLUP(expression[,...])

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY avi_typavi,qlf_annee;

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(avi_typavi,qlf_annee);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY cmp_compa,avi_typavi,qlf_annee;

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(cmp_compa,avi_typavi,qlf_annee);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY ROLLUP (cmp_compa,avi_typavi),ROLLUP(qlf_annee);

-- GROUP BY CUBE(expression [,...])

SELECT   cmp_compa,avi_typavi,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi,qlf_annee);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY GROUPING SETS((cmp_compa,avi_typavi),qlf_annee,());

DROP TABLE T_qualifs_qlf;
GO
